TITLE   'Permanent Magnetization'			         { exa136.pde }
SELECT     					{ Professional Version }
   errlim=1e-4     ngrid=1     spectral_colors	
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   A_phi
DEFINITIONS                      			{ Uniform magnetization }	
   L=1.0     r0=0.1    Lz=0.1     J_phi=0     Mz0     Mz00=1e5
   mu0=4*pi*1e-7     mu=mu0 	
   Br=-dz(A_phi)     Bz=1/r*dr(r*A_phi)
   B=vector( Br, Bz)     Bm=magnitude( B)
   Hr=Br/mu0-0     Hz=Bz/mu0-Mz0		{ Mr0=0 }
   H=vector( Hr, Hz)   Hm=magnitude( H)   Mz=Bz/mu0-Hz
   z1=z+Lz     Bz_ex=					{ Continued on next line }
   mu0*Mz00/2*[ z1/sqrt(z1^2+r0^2)- (z1-2*Lz)/sqrt((z1-2*Lz)^2+r0^2)]
EQUATIONS
   dz( Hr)- dr( Hz)=J_phi
BOUNDARIES
region 'domain' Mz0=0  start 'outer' (0,-L) value(A_phi)=0
   line to (2*L,-L) to (2*L,L) to (0,L) line to close
region 'magnet' Mz0=Mz00
   start (0,-Lz) line to (r0,-Lz) to (r0,Lz) to (0,Lz)
   mesh_spacing=0.1*Lz line to close
PLOTS
   contour( Hz) painted     contour( Mz) painted
   contour( Bz) painted
   elevation( Bz, Bz_ex) from (0,-2*Lz) to (0,2*Lz)
   vector( H) norm zoom(0,-3*Lz,  6*Lz,6*Lz)
   vector( B) norm zoom(0,-3*Lz,  6*Lz,6*Lz)
   contour( Hz+Mz) painted zoom(0,-3*Lz,  6*Lz,6*Lz)
   elevation( Hz+Mz) from (0,0) to (2*r0,0)
END


